/*
 * EffectTask.h
 *
 * Created 8/30/2009 By Johnny Huynh
 *
 * Version 00.00.01 8/30/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef EFFECT_TASK_H
 #define EFFECT_TASK_H
 
 template <typename T> class EffectTask;
 
 #include "global.h"
 
 #include "ActionTask.h"
 #include "genericAsyncTask.h"
 #include "deletedChain.h"
 #include "asyncTaskManager.h"
 #include "ActionInfo.h"
 #include "Ralph.h"
 #include "StringConversion.h"
 
 /**
  * Class specification for EffectTask
  */
 template <typename T>
 class EffectTask : public ActionTask<T>
 {
 // Data Members
 private:
    
 // Local Functions
 public:
    EffectTask( Object<T>* const object_Ptr, ActionInfo<T>* action_info_Ptr );
    EffectTask( const string& name, ActionInfo<T>* action_info_Ptr );
    EffectTask( const string& name, GenericAsyncTask::TaskFunc* function, ActionInfo<T>* action_info_Ptr, void* user_data = NULL );
    EffectTask( const EffectTask<T>& effect_task );
    ALLOC_DELETED_CHAIN( EffectTask ); // Needed to accommodate additional data members (e.g. see ActionTask.h)
    virtual ~EffectTask();
    inline EffectTask<T>& operator=( const EffectTask<T>& effect_task );
    virtual inline void add_to_task_manager();
 
 // Private Functions
 private:
    
 // Friend Functions
 public:
 
 };
 
 /** LOCAL FUNCTIONS **/
 
 /**
  * Constructor
  */
 template <typename T>
 EffectTask<T>::EffectTask( Object<T>* const object_Ptr, ActionInfo<T>* action_info_Ptr )
               : ActionTask<T>( object_Ptr, action_info_Ptr )
 {
    nassertv( object_Ptr != NULL );
    nassertv( action_info_Ptr != NULL );
 }
 
 /**
  * Alternative Constructor
  */
 template <typename T>
 EffectTask<T>::EffectTask( const string& name, ActionInfo<T>* action_info_Ptr )
               : ActionTask<T>( name, action_info_Ptr )
 {
    nassertv( action_info_Ptr != NULL );
 }
 
 /**
  * Alternative Constructor
  */
 template <typename T>
 EffectTask<T>::EffectTask( const string& name, GenericAsyncTask::TaskFunc* function, ActionInfo<T>* action_info_Ptr, void* user_data )
               : ActionTask<T>( name, function, action_info_Ptr, user_data )
 {
    nassertv( function != NULL );
    nassertv( action_info_Ptr != NULL );
 }
 
 /**
  * Copy Constructor
  */
 template <typename T>
 EffectTask<T>::EffectTask( const EffectTask<T>& effect_task )
               : ActionTask<T>( effect_task )
 {
    
 }
 
 /**
  * Destructor
  */
 template <typename T>
 EffectTask<T>::~EffectTask()
 {
    
 }
 
 /**
  * operator=() copies the content of the specified EffectTask to this EffectTask.
  *
  * @param (const EffectTask<T>&) effect_task
  * @return EffectTask<T>&
  */
 template <typename T>
 inline EffectTask<T>& EffectTask<T>::operator=( const EffectTask<T>& effect_task )
 {
    ActionTask<T>::operator=( effect_task );
    
    return *this;
 }
 
 /**
  * add_to_task_manager() adds this EffectTask to the AsyncTaskManager that handles effects.
  */
 template <typename T>
 inline void EffectTask<T>::add_to_task_manager()
 {
    nassertv( ActionTask<T>::get_action_info() != NULL );
    ActionTask<T>::add_to_task_manager( global::_task_mgr_Ptr );
 }
 
 /** FRIEND FUNCTIONS **/
 
 #endif // EFFECT_TASK_H